<?php
// Include the framework only if another plugin has not already done so
if ( ! class_exists('WordPress_SimpleSettings') )
	require('inc/wordpress-settings.php'); 
class ElementorPageIntro extends WordPress_SimpleSettings {
	var $prefix = 'elementor-page-intro'; // this is super recommended
	function __construct() {
		parent::__construct(); // this is required
		// Actions
		add_action('admin_menu', array($this, 'menu') );
		register_activation_hook(__FILE__, array($this, 'activate') );
	}
	function menu () {
		add_options_page("Elementor Page Intro", "Elementor Page Intro", 'manage_options', "elementor-page-intro", array($this, 'admin_page') );
	}
	function admin_page () {
		include 'admin-options.php';
	}
	function activate() {
		$this->add_setting('favorite_color', 'red');
		$this->add_setting('favorite_array', 'element 1;element 2;element 3;');
	}
}
$ElementorPageIntro = new ElementorPageIntro();
?>